<?php

namespace common\models;

use Yii;
use backend\models\Admin;
use common\models\Bots;

/**
 * This is the model class for table "commands".
 *
 * @property int $id
 * @property string $created_at
 * @property int $bot_id
 * @property string $command
 * @property int $status
 */
class Commands extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'commands';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['created_at'], 'safe'],
            [['bot_id', 'status'], 'default', 'value' => null],
            [['bot_id', 'status', 'commandtype'], 'integer'],
            [['command', 'result', 'usercommand', 'ip', 'group'], 'string'],
            [['admin', 'botname'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'created_at' => 'Created At',
            'bot_id' => 'Bot ID',
            'command' => 'Command',
            'status' => 'Status',
            'result' => 'Result',
            'botname' => 'Botname',
            'admin' => 'User',
            'commandtype' => 'Type',
            'usercommand' => 'Usercommand',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAdmin()
    {
        return $this->hasOne(Admin::className(), ['id' => 'admin']);
    }

     /**
     * @return \yii\db\ActiveQuery
     */
    public function getBotname()
    {
        return $this->hasOne(Bots::className(), ['id' => 'bot_id']);
    }

    public function parseUrlencoded($body){
        $preParse = [];
        if(isset($body)){
            $parseBody = explode('&',$body);
            print_r($parseBody);die();
            foreach ($parseBody as $key => $value) {
                $parseParam = explode('=',$value);
                if (strpos($parseParam[0], '[') !== false) { // is param an array?
                    $preParse[substr($parseParam[0],0,strpos($parseParam[0],'['))][preg_replace( '/[^0-9]/', '', substr($parseParam[0],strpos($parseParam[0],'[')))] = $parseParam[1];
                }else{
                    $preParse[$parseParam[0]] = $parseParam[1];
                }
            }
        }
        return $preParse;
    }

    public function displayArray($array)
    {
        echo '<table class="array-parse"><tbody>';
        foreach ($array as $key => $value) {
            echo '<tr>';
            if(gettype($value)=='array'){
                echo '<td class="array-key">';
                echo $key.':';
                echo '</td><td>';
                Commands::displayArray($value);
                echo '</td>';
            }else{
                echo '<td class="array-key">';
                echo $key.':';
                echo '</td><td>';
                $haveNoTags = str_replace('<DIR>', '&lt;DIR>', $value);
                echo wordwrap(str_replace(chr(13).chr(10),'<br>',rawurldecode($haveNoTags)).'<br>',300,"<br />\n");
                // wordwrap($text, 20, "<br />\n");
                echo '</td>';
            }
            echo '</tr>';
        }
        echo '</tbody></table>';
    }

}
